
;**********************************************************************
;                                                                     *
;    Filename:	    00016R1.asm                                       *
;    Date:          31aug04	                                          *
;    File Version:     pp1                                            *
;                                                                     *
;    Author:  M Waldron                                               *
;    Company: MCHP                                                    *
;	 10f204/ 10f206 PWM to control LED driver                         * 
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files required:                                                  *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes: Changed file name, added led_medhi routine,               *
;     	    adjusted intensity of various modes.  PB 3/29/05      	  *	
;	 		                                                          *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************


		list p=10f206         		; list directive to define processor
		#include <p10f206.inc>      ; processor specific variable definitions

	
    __CONFIG _CP_OFF & _WDT_OFF & _MCLRE_OFF & _IntRC_OSC


; '__CONFIG' directive is used to embed configuration data within .asm file.
; The labels following the directive are located in the respective .inc file.
; See respective data sheet for additional information on configuration word.

;constants 
;increase led_xxx_on to increase intensity ( value must be less than period value)
;increase period to reduce PWM frequency and increase PWM resolution
led_hi_on	  =	0x16		;on loops for high brightness mode
led_hi_off	  = 0x11		;off loops for high brightness mode, value will be calculated by the program (10)
led_medhi_on  =	0x08		;on loops for medium_high brightness mode
led_medhi_off = 0x11 		;off loops for high brightness mode (11)
led_med_on	  =	0x06		;on loops for medium brightness mode
led_med_off	  = 0x11 		;off loops for high brightness mode (11)
led_low_on    =	0x05		;on loops for low brightness mode
led_low_off	  = 0x12		;off loops for high brightness mode (12)
period		  =	0x0E		;total loops per PWM period
max_time	  =	0xff		;on time before unit swithces back to sleep

;variables
mode		  = 0x13		;current mode ( high, med, lo )
counter		  = 0x14		;hi and low time counter
debounce	  =	0x15		;debounce counter
flag		  =	0x16		;debounce control flags
timerh		  =	0x17		;on timer high byte
timerl		  =	0x18		;on timer low byte

;bits used in the flag variable
new_mode	=	7			;when set a debounced user keypress has been detected
timer_ena	=	6			;when clear the debounce timer will not increment

;GPIO pins
button 		=	3			;mode select button
pwm			=	0			;pwm output

;other
TO                       EQU     H'0004'
PD                       EQU     H'0003'
GPWU                     EQU     H'0007'
GPPU                     EQU     H'0006'
COUTEN		             EQU     H'0006'
CMPT0CS                  EQU     H'0004'
CWU                      EQU     H'0000'

	org 0x00
			goto reset

	org 0x10

reset		nop
			nop
			bcf OSCCAL, FOSC4       ; GP2/T0CKI/COUT applied to GP2 pin
init_ports	movlw 0x01				;initalize mode, upon wake up led will be at low intensity 
			movwf mode
			;
			movlw b'00001111'		;configure for wake on port change
		    OPTION
			;
			movlw b'01010011'		;disable the comparator
			movwf 0x07				;write to CMCON0		
			;
			clrf GPIO
			movlw 0x0E
			tris GPIO				;configure port
			;
			bcf STATUS, GPWUF
			btfsc STATUS, CWUF		;test for wake up or reset 
			goto wake
			btfsc STATUS, GPWUF 
			goto wake
			btfss STATUS, TO 
			goto wake	
			btfss STATUS, PD 
			goto wake
			goto init_vars			;initialize vars

init_vars	movlw 0xFF
			movwf timerh
			movwf timerl
			;	
			movlw led_hi_on			;calculate off times based on time remaining in PWM period 			
			movwf led_hi_off		;add the complement of on time to the window time
			comf led_hi_off, f
			movlw period
			addwf led_hi_off, f
			;
			movlw led_medhi_on		;calculate off times based on time remaining in PWM period 			
			movwf led_medhi_off		;add the complement of on time to the window time
			comf led_medhi_off, f
			movlw period
			addwf led_medhi_off, f
			;
			movlw led_med_on		;calculate off times based on time remaining in PWM period 			
			movwf led_med_off		;add the complement of on time to the window time
			comf led_med_off, f
			movlw period
			addwf led_med_off, f
			;
			movlw led_low_on		;calculate off times based on time remaining in PWM period 			
			movwf led_low_off		;add the complement of on time to the window time
			comf led_low_off, f
			movlw period
			addwf led_low_off, f
			;
			movf GPIO, w			;read port before entering sleep mode
    		sleep
			
wake		btfss GPIO, button		;only allow a low to bring PIC out of sleep
			goto inc_mode
			movlw 0x20
			call delay
			movf GPIO, w
			sleep					
			;
inc_mode	incf mode, f			;it was a pin change, determine new mode
			
			;determine current mode
mode_select	bcf flag, new_mode		;clear new mode flag
			;			
			movlw 0x01			
			subwf mode, w
			btfsc STATUS, Z
			goto led_off
			;
			movlw 0x02	
			subwf mode, w
			btfsc STATUS, Z
			goto led_low
			;
			movlw 0x03	
			subwf mode, w
			btfsc STATUS, Z
			goto led_med
			;
			movlw 0x04	
			subwf mode, w
			btfsc STATUS, Z
			goto led_medhi
			;
			movlw 0x05	
			subwf mode, w
			btfsc STATUS, Z
			goto led_high
			;
			movlw 0x06	
			subwf mode, w
			btfsc STATUS, Z
			goto led_full
			;
			movlw 0x01				;on mode rollover reset to low brightness mode
			movwf mode
			goto mode_select
			
			;full on
led_full	bsf GPIO, pwm
			movlw 0x0F		
			call delay				;used as debounce
			call bounce
			btfss flag, new_mode
			goto led_full
			goto mode_select

			;high brightness routine
led_high	bsf GPIO, pwm				;turn on LED(s) for a set time
			movlw led_hi_on		
			call delay
			bcf GPIO, pwm				;turn off LED(s) fo a set time
			movf led_hi_off, w		
			call delay
			call bounce
			btfss flag, new_mode
			goto led_high
			goto mode_select
			;medium-high brightness routine
led_medhi	bsf GPIO, pwm				;turn on LED(s) for a set time
			movlw led_medhi_on		
			call delay
			bcf GPIO, pwm				;turn off LED(s) fo a set time
			movf led_medhi_off, w		
			call delay
			call bounce
			btfss flag, new_mode
			goto led_medhi
			goto mode_select	
			;medium brightness routine
led_med		bsf GPIO, pwm				;turn on LED(s) for a set time
			movlw led_med_on		
			call delay
			bcf GPIO, pwm				;turn off LED(s) fo a set time
			movf led_med_off, w		
			call delay
			call bounce
			btfss flag, new_mode
			goto led_med
			goto mode_select

			;low brightness routine
led_low		bsf GPIO, pwm				;turn on LED(s) for a set time
			movlw led_low_on		
			call delay
			bcf GPIO, pwm				;turn off LED(s) for a set time
			movf led_low_off, w		
			call delay
			call bounce
			btfss flag, new_mode
			goto led_low
			goto mode_select

			;led off
led_off		movlw 0x20
			call delay
			bcf GPIO, pwm				;turn off LED(s)
			movf GPIO, w			    ;read port before entering sleep mode  
			sleep
			
			;delay loop for on and off time
delay		movwf counter            ; Delay = (3 + (3 * counter) + 2) Tcy
loop		decfsz counter, f
			goto loop
			retlw 0x00

			;check for button press
bounce		btfss GPIO, button      ; Is Button Depressed?
			goto bounce1            ; Yes, go to "bounce1"
			bsf flag, timer_ena		; No, allow timer to start
			clrf debounce			; no user entry, reset debounce timer
			retlw 0x00              ; 
bounce1	    btfss flag, timer_ena
			retlw 0x00				;do not increment as we have not seen the debounce released yet
			incfsz debounce, f		;inc debounce timer
			retlw 0x00				;not yet 
			bsf flag, new_mode
			incf mode, f			;a valid press has been detected
			bcf flag, timer_ena		;prevent timer from incrementing to prevent cycling though modes by holding debounce
bounce00	retlw 0x00


end


			
